--[[
  Library for tweaking settings of digital instruments. Ideally, I’d recommend to use scriptable textures, or set
  a car script altering textures once needed, but if you want to use the more classical approach, this library
  might help.

  To use, include with `local di = require('shared/sim/di')`. All tweaks target current car, which for apps and such
  can be changed with `ac.setTargetCar()`. For car scripts, target car can’t be changed.
]]
---@diagnostic disable

local di = { item = {}, led = {} }

di.item.Property = {
  Color = 0, -- Color for text nodes, digital nodes, or a base color. Type: `rgbm`.
  Scale = 1, -- Scale of text nodes. Type: `number`.
  Size = 2, -- Size of digital nodes. Type: `vec2`.
  Prefix = 3, -- Prefix. Type: `string`.
  Postfix = 4, -- Postfix. Type: `string`.
  Text = 5, -- Text of text nodes. Type: `string`.
  Trigger = 6, -- Trigger value of display nodes. Type: `number`.
  SecondaryColor = 7, -- Secondary color. Type: `rgbm`.
  TertiaryColor = 8, -- Tertiary color. Type: `rgbm`.
}

di.led.Property = {
  Color = 0, -- Primary emissive color. Type: `rgb`.
  SecondaryColor = 1, -- Secondary emissive color. Type: `rgb`.
  TertiaryColor = 2, -- Tertiary emissive color. Type: `rgb`.
  Switch = 3, -- Switch value. Type: `number`.
  BlinkFrequency = 4, -- Blinking frequency. Type: `number`.
  BlinkSwitch = 5, -- Blinking switch value. Type: `number`.
}

---@param itemIndex integer @0-based item index (N from `[ITEM_N]`).
---@param property integer @Property to edit, one of `di.item.Property`.
---@param value any @Value to set. If type doesn’t match, shouldn’t do anything.
---@return boolean @Returns `false` if there is no such item, or if selected property is not available for that item.
function di.item.set(itemIndex, property, value) return itemIndex >= 0 and __util.native() end

---@param itemIndex integer @0-based item index (N from `[ITEM_N]`).
---@param property integer @Property to access, one of `di.item.Property`.
---@return any? @Returns `nil` if there is no such item, or if selected property is not available for that item.
function di.item.get(itemIndex, property, property) if itemIndex >= 0 then return __util.native() else return nil end end

---@param ledIndex integer @0-based LED index (N from `[LED_N]`).
---@param property integer @Property to edit, one of `di.led.Property`.
---@param value any @Value to set. If type doesn’t match, shouldn’t do anything.
---@return boolean @Returns `false` if there is no such item, or if selected property is not available for that item.
function di.led.set(ledIndex, property, value) return ledIndex >= 0 and __util.native() end

---@param ledIndex integer @0-based LED index (N from `[LED_N]`).
---@param property integer @Property to access, one of `di.led.Property`.
---@return any? @Returns `nil` if there is no such item, or if selected property is not available for that item.
function di.led.get(ledIndex, property) if ledIndex then return __util.native() else return nil end end

return di
