--[[
  Library with a bunch of functions for creating custom replay UI. Available to scripts with Game API access only (Lua apps, new modes).

  To use, include with `local replay = require('shared/ui/replay')`.
]]

local replay = {}

---@return integer @Returns number of recorded frames.
function replay.getReplayTotalFrames() return __util.native() end

---@return integer @Returns replay duration in seconds.
function replay.getReplayTotalTime() return __util.native() end

---Save replay to a file.
---@param filename string @Replay name or filename. If not a full path, will be saved relative to replay folder.
---@return boolean @Returns `false` if failed.
function replay.saveReplay(filename) return __util.native() end

return replay