--[[
  Basic OpenKneeboard API. Available to all.
  
  To use, include with `local openKneeboard = require('shared/utils/openkneeboard')` and then call `openKneeboard.send('RemoteUserAction', 'NEXT_TAB')`.
]]
---@diagnostic disable

-- Actual library:
local openKneeboard = {}

---Check if OpenKneeboard API is available. Tries to load API, returns `false` if failed.
---@return boolean @Returns `true` if API is available.
function openKneeboard.available()
  return __util.native()
end

---Send a message to OpenKneeboard. More information about messages is available at <https://openkneeboard.com/api/messages/>.
---@param name string @Message name.
---@param value string|table @Message value. If table is passed, it’ll be JSON-ified.
---@return boolean @Returns `false` if API is not available (usually, when CSP can’t find OpenKneeboard).
function openKneeboard.send(name, value)
  return __util.native('openkneeboard_cmd', true, name, type(value) == 'table' and JSON.stringify(value) or value)
end

return openKneeboard
