--[[
  Some Steam VR related functions.
  
  To use, include with `local steamVR = require('shared/vr/steamvr')`.
]]
---@diagnostic disable

-- Actual library:
local steamVR = {}

---Check if Steam VR API is available.
---@return boolean
function steamVR.isAvailable()
  return __util.native()
end

---Use to determine if the headset display is part of the desktop (i.e. extended) or hidden (i.e. direct mode).
---@return boolean @If not available, returns `false`.
function steamVR.isDisplayOnDesktop()
  return __util.native()
end

---Set the display visibility.
---@param value boolean @Pass `true` for extended or `false` for direct mode.
---@return boolean @Return value of true indicates that the change was successful.
function steamVR.setDisplayVisibility(value)
  return __util.native()
end

---Returns the transform from the seated zero pose to the standing absolute tracking system. This allows
---applications to represent the seated origin to used or transform object positions from one coordinate
---system to the other.
---@param type 'seated'|'raw' @Type of a zero pose to get.
---@return mat4x4 @If not available, returns empty `mat4x4`.
function steamVR.getZeroPose(type)
  return __util.native()
end

return steamVR
