--[[
  Library with UI components corresponding to different parts of AC. Can be useful for creating custom UI.

  To use, include with `local components = require('shared/ui/components')`.
]]

local components = {}

---Online, this piece is the chat, and this table can help draw it in a custom main menu. With a new mode, it could be something else. Also, in hotlap mode, it could be a custom piece too.
components.MainMenuModePiece = {}

---@return boolean @Returns `true` if there is a UI piece related to the current race mode configured and ready to be drawn.
function components.MainMenuModePiece.present() return __util.native() end

---@return string? @Returns the title of the UI piece, or `nil` if piece is not configured.
function components.MainMenuModePiece.title() return __util.native() end

---@return number? @Returns the height hint of the UI piece, or `nil` if piece is not configured. Height hint is a value you can consider when allocating the space for the piece, but it’s entirely optional.
function components.MainMenuModePiece.height() return __util.native() end

---@return boolean? @Returns `true` if UI piece also has a separate settings content configured, or `nil` if piece is not configured at all.
function components.MainMenuModePiece.hasSettings() return __util.native() end

---Draw piece contents. Ideally, create a new window, call this function and end the window, without moving cursor or anything like that. Do not rely on
---the implementation of the piece render logic (for example, replacing icon in a “send” button of the chat online by drawing a new icon on top can cause undesired effects later when the button would be moved). 
function components.MainMenuModePiece.content() return __util.native() end

---Draw piece settings (use `.hasSettings()` to check if there is anything). Ideally, create a new popup window with auto-resize, call this function and end the window, without moving cursor or anything like that.
function components.MainMenuModePiece.settings() return __util.native() end

---This piece is for offline mode, allows to edit assists in-game.
components.AssistsEditor = {}

---@return boolean @Returns `true` if CSP can draw an assists editor (available offline unless current race is restricted, like, if RSS is present).
function components.AssistsEditor.present() return __util.native() end

---@return string? @Returns the title of the assists editor, or `nil` if piece is not configured.
function components.AssistsEditor.title() return __util.native() end

---@return number? @Returns the height hint of assists editor, or `nil` if it’s not available. Height hint is a value you can consider when allocating the space for the piece, but it’s entirely optional.
function components.AssistsEditor.height() return __util.native() end

---@return boolean? @Returns `true` if assists editor also has a separate settings content configured, or `nil` if piece is not configured at all.
function components.AssistsEditor.hasSettings() return __util.native() end

---Draw assists editor contents.
function components.AssistsEditor.content() return __util.native() end

---Draw assists editor settings (use `.hasSettings()` to check if there is anything). Ideally, create a new popup window with auto-resize, call this function and end the window, without moving cursor or anything like that.
function components.AssistsEditor.settings() return __util.native() end

return components